﻿var eApp = angular.module('eApp', ['chieffancypants.loadingBar', 'ngDialog', 'angularUtils.directives.dirPagination', 'pascalprecht.translate']);
eApp.controller('HomeContr', function ($rootScope, $scope, $timeout, cfpLoadingBar, CommService, $translate, $sce, $location) {
    cfpLoadingBar.start();

    $scope.domain = $sce.trustAsHtml($location.protocol() + "://" + $location.host() + ($location.port() == "" ? "" : ":" + $location.port()) + "/");
       
    //if (CommService.GetRoleId() == '1' && CommService.GetUserType() == '1' && CommService.GetUserDesignation() == '1')
    //{
    //    FillDepartments();
    //}

    $rootScope.signOut = function signOut(logout) {
        window.localStorage.removeItem("token");
        window.localStorage.removeItem("userid");
        window.localStorage.removeItem("isLoginUserAdmin");
        window.localStorage.removeItem("SessionTransferProposalID");
        window.location.href = 'sso-login.html';

    };
 
    $scope.Reset = function Reset() {
        window.location.reload("../../Dashboard/index.html");
    }
    
});

eApp.controller('OtherController', function ($scope) {
    $scope.pageChangeHandler = function (num) {
        console.log('going to page ' + num);
    };
});

eApp.controller('LoadMenuCont', function ($scope, $sce, CommService, $location, $rootScope) {

    $scope.domainName = $location.protocol() + "://" + $location.host() + ($location.port() == "" ? "" : ":" + $location.port()) + "/";   

    var Language_Id = "0";
    if (window.localStorage.getItem("Language") == null || window.localStorage.getItem("Language") == undefined) {
        window.localStorage.setItem("Language", 'de');
        Language_Id = 2;
    }
    if (window.localStorage.getItem("Language") == 'en') {
        $scope.rbEnglish = true;
        Language_Id = 1;
    }
    else {
        $scope.rbHindi = true;
        Language_Id = 2;
    }
    $scope.side_menu = function () {
        //alert('');
    }
    $scope.MenuFill = [];

    setTimeout(function () { Layout.init(); Layout.initSidebarCustom($location.absUrl(), $scope.domainName); $scope.setPageTitle($location.absUrl()); }, 1000);

    $scope.setPageTitle = function (url) {
        
        $rootScope.LoginTitle = $('a[href^="' + url + '"]').text();
        $rootScope.LoginTitlePage = url.split('/')[3];

        var link = document.createElement('link');
        link.id = 'TPS';
        link.rel = 'icon';
        link.href = $scope.domainName + 'favicon.ico';
        document.head.appendChild(link);
    }
});

eApp.controller('Comm-Ctl', function ($scope, $sce, CommService, $location, Excel, $timeout) {

    $('.print_show').css("display", "none");
    $scope.ListWorkStatus = [];
    $scope.ListPageSize = [];
    $scope.ListWorkStatus = [{ "id": "NA", "status": "Initiate" },
                            { "id": "Request", "status": "Request" },
                            { "id": "Approved", "status": "Approved2" }, ]

    $scope.ListPageSize = [
                            { "id": "", "value": "", "text": "All Record" },
                            { "id": "1", "value": "50", "text": "50 Record" },
                            { "id": "2", "value": "100", "text": "100 Record" },
                            { "id": "3", "value": "200", "text": "200 Record" },
                            { "id": "4", "value": "500", "text": "500 Record" }]

    //$scope.printDiv = function (w, h, report_id, work_id) {
    //    var created_by = CommService.GetUserId();
    //    var title = 'a';
    //    var left = (screen.width / 3) - (w / 3);
    //    var top = (screen.height / 4) - (h / 4);
    //    return window.open('../Include/Esign.aspx?User_id=' + created_by + '&&report_id=' + report_id + "&&work_id=" + work_id + "&&WORKAREA=AS", title, 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width=' + w + ', height=' + h + ', top=' + top + ', left=' + left);
    //}

    //$scope.so_id = CommService.GetUserId();

    //$scope.department_name = CommService.GetDepartmentName();

    $scope.exportData = function (tableId) { // ex: '#my-table'

        var exportHref = Excel.tableToExcel(tableId, 'TPS DoITC');
        
        $timeout(function () { location.href = exportHref; }, 100); // trigger download
    }

    $scope.exportDataDownload = function (tableId, linkID) { // ex: '#my-table'

        var exportHref = Excel.tableToExcel(tableId, 'TPS DoITC');

        const downloadLink = document.createElement('a');

        $timeout(function () {
            //location.href = exportHref;
            
            downloadLink.href = exportHref;
            downloadLink.download = 'download.xls';
            downloadLink.click();
            
        }, 5000); // trigger download
    }

    $scope.printGridDiv = function (divName) {
        $('.print_hide').css("display", "none");
        $('.print_show').css("display", "block");
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;

        var header = '<div style="padding:10px;width:100%; text-align:center"><img src="assets/img/logo.png" alt="Logo"></div>';

        document.body.innerHTML = header + printContents;
        window.print();
        document.body.innerHTML = originalContents;
        window.location.reload();
    }

    $scope.scroll_top = function () { $('html, body').animate({ scrollTop: 0 }, 500); }

    $scope.NumToWord = function (num) {
        if (typeof (num) != "undefined") {

            num = parseInt(num);
            if (num == 0)
                return "Zero";

            var a = ['', 'One ', 'Two ', 'Three ', 'Four ', 'Five ', 'Six ', 'Seven ', 'Eight ', 'Nine ', 'Ten ', 'Eleven ', 'Twelve ', 'Thirteen ', 'Fourteen ', 'Fifteen ', 'Sixteen ', 'Seventeen ', 'Eighteen ', 'Nineteen'];
            var b = ['', '', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];

            if ((num = num.toString()).length > 11) return 'overflow';
            n = ('00000000000' + num).substr(-11).match(/^(\d{2})(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return; var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'Arab ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'Crore ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'Lakh ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'Thousand ' : '';
            str += (n[5] != 0) ? (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'Hundred ' : '';
            str += (n[6] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[6])] || b[n[6][0]] + ' ' + a[n[6][1]]) + 'only ' : '';
            return str;
        }
    }

    $scope.GetToggleURL = function (param) {
        $scope.filter_type = param;
        return '../../Common/View/toggler.html';
    }

});

eApp.value("eAppVal", { GridPageSize: 50 });

eApp.config(function (cfpLoadingBarProvider, $translateProvider, $httpProvider) {
    debugger
    $httpProvider.defaults.headers.post = { '__RequestSecureToken': window.localStorage.getItem("token") }
    if (window.localStorage.getItem("token") == null || window.localStorage.getItem("token") == undefined) {
        window.location.href = '../../sso-login.html';
    }
    cfpLoadingBarProvider.includeSpinner = true;
});

eApp.run(function ($rootScope, $timeout, $document) {
    
    $rootScope.LoginLogo = window.localStorage.getItem("InnerLogo");
    $rootScope.LoginTitle = window.localStorage.getItem("PageTitle");
    $rootScope.UserProfilePic = window.localStorage.getItem("ProfileImg");
    $rootScope.HeaderUId = window.localStorage.getItem("userid");
    $rootScope.HeaderUName = window.localStorage.getItem("name");
    $rootScope.IsAdminUser = window.localStorage.getItem("isLoginUserAdmin");

    $rootScope.TokenExpire = function () {
        message_error("Token Expired", "Oops! You are not authorized to process any request. Login again.", function () { $rootScope.signOut(); });
    }

    // Auto Logout Module Created By Anil P

    // Timeout timer value
    var TimeOutTimerValue = 1000 * (30 * 60); // In seconds

    // Start a timeout
    var TimeOut_Thread = $timeout(function () { LogoutByTimer() }, TimeOutTimerValue);
    var bodyElement = angular.element($document);

    /// Keyboard Events
    bodyElement.bind('keydown', function (e) { TimeOut_Resetter(e) });
    bodyElement.bind('keyup', function (e) { TimeOut_Resetter(e) });

    /// Mouse Events    
    bodyElement.bind('click', function (e) { TimeOut_Resetter(e) });
    bodyElement.bind('mousemove', function (e) { TimeOut_Resetter(e) });
    bodyElement.bind('DOMMouseScroll', function (e) { TimeOut_Resetter(e) });
    bodyElement.bind('mousewheel', function (e) { TimeOut_Resetter(e) });
    bodyElement.bind('mousedown', function (e) { TimeOut_Resetter(e) });

    /// Touch Events
    bodyElement.bind('touchstart', function (e) { TimeOut_Resetter(e) });
    bodyElement.bind('touchmove', function (e) { TimeOut_Resetter(e) });

    /// Common Events
    bodyElement.bind('scroll', function (e) { TimeOut_Resetter(e) });
    bodyElement.bind('focus', function (e) { TimeOut_Resetter(e) });

    function LogoutByTimer() {
        window.localStorage.removeItem("token");
        message_error("TimeOut", "You session is timeout. Please login again.", function () { $rootScope.signOut(); });
    }
    function TimeOut_Resetter(e) {

        if (window.localStorage.getItem("token") == '') {
            LogoutByTimer();
        }
       
        /// Stop the pending timeout
        $timeout.cancel(TimeOut_Thread);
        /// Reset the timeout
        TimeOut_Thread = $timeout(function () { LogoutByTimer() }, TimeOutTimerValue);
    }

});

eApp.service('CommService', function ($http, $sce, $rootScope, $location) {
       
    $rootScope.url = "/";

    this.getQueryStrings = function getQueryStrings() {
        var assoc = {};
        var decode = function (s) { return decodeURIComponent(s.replace(/\+/g, " ")); };
        var queryString = location.search.substring(1);
        var keyValues = queryString.split('&');

        for (var i in keyValues) {
            var key = keyValues[i].split('=');
            if (key.length > 1) {
                assoc[decode(key[0])] = decode(key[1]);
            }
        }
        return assoc;
    };

    this.GetUserName = function GetUserName() {
        return window.localStorage.getItem("name");
    };

    this.GetUserId = function GetUserId() {
        return window.localStorage.getItem("userid");
    };

    this.GetIsLoginUserAdmin = function GetIsLoginUserAdmin() {
        return window.localStorage.getItem("isLoginUserAdmin");
    };

    this.Getssomapping_id = function Getssomapping_id() {
        return window.localStorage.getItem("ssomapping_id");
    };
       
    this.Logoutuser = function (UserId) {
        var formData = new FormData();
        formData.key = "LogOutUser";
        formData.UserId = UserId;
        saveSts = $http({
            data: formData, method: 'post',
            url: $rootScope.url + 'Handler/UserActivity.ashx',
            datatype: "json"
        }).success(function (rsp) {
            RspData = rsp;
            return RspData;
        }).error(function (rsp) {

        });
        return saveSts;
    };

    this.LoadLogoPath = function () {
        var formData = new FormData();
        formData.key = "LoadLogoPath";
        saveSts = $http({
            data: formData, method: 'post',
            url: $rootScope.url + 'Handler/LogoPath.ashx',
            datatype: "json"
        }).success(function (rsp) {
            RspData = rsp;
            return RspData;
        }).error(function (rsp) {
            //alert('Error');
            console.log('Error');
        });
        return saveSts;
    };

});

eApp.directive('emptyGrid', function () {
    return {
        restrict: 'A',
        template: '<div class="alert alert-info alert-GvEmpty">No Record Found !</div>',
        scope: {
        }
    };
});

eApp.directive('modal', function () {
    return {
        template: '<div class="modal fade">' +
          '<div class="modal-dialog">' +
            '<div class="modal-content">' +
              '<div >' +
                '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                '<h4 class="modal-title">{{ title }}</h4>' +
              '</div>' +
              '<div class="modal-body" ng-transclude></div>' +
            '</div>' +
          '</div>' +
        '</div>',
        restrict: 'E',
        transclude: true,
        replace: true,
        scope: true,
        link: function postLink(scope, element, attrs) {
            scope.title = attrs.title;

            scope.$watch(attrs.visible, function (value) {
                if (value == true)
                    $(element).modal('show');
                else
                    $(element).modal('hide');
            });

            $(element).on('shown.bs.modal', function () {
                scope.$apply(function () {
                    scope.$parent[attrs.visible] = true;
                });
            });

            $(element).on('hidden.bs.modal', function () {
                scope.$apply(function () {
                    scope.$parent[attrs.visible] = false;
                });
            });
        }
    };
});

eApp.factory('Excel', function ($window) {
    var uri = 'data:application/vnd.ms-excel;base64,',
        template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>',
        base64 = function (s) { return $window.btoa(unescape(encodeURIComponent(s))); },
        format = function (s, c) { return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; }) };
    return {
        tableToExcel: function (tableId, worksheetName) {

            var filterData = $('#' + tableId);
            $(filterData).find('tr.footerPaging').remove();

            var table = filterData,
                ctx = { worksheet: worksheetName, table: table.html() },
                href = uri + base64(format(template, ctx));
            return href;
        }
    };
})

eApp.directive('allowOnlyNumbers1', function () {
    return {
        restrict: 'A',
        link: function (scope, elm, attrs, ctrl) {
            elm.on('keydown', function (event) {
                if (event.which == 64 || event.which == 16) {
                    // to allow numbers  
                    return false;
                } else if (event.which >= 48 && event.which <= 57) {
                    // to allow numbers  
                    return true;
                } else if (event.which >= 96 && event.which <= 105) {
                    // to allow numpad number  
                    return true;
                } else if ([8, 13, 27, 37, 38, 39, 40].indexOf(event.which) > -1) {
                    // to allow backspace, enter, escape, arrows  
                    return true;
                } else {
                    event.preventDefault();
                    // to stop others  
                    return false;
                }
            });
        }
    }
});

eApp.directive('allowOnlyNumbers', function () {
    return {
        require: 'ngModel',
        link: function (scope) {
            scope.$watch('wks.number', function (newValue, oldValue) {
                var arr = String(newValue).split("");
                if (arr.length === 0) return;
                if (arr.length === 1 && (arr[0] == '-' || arr[0] === '.')) return;
                if (arr.length === 2 && newValue === '-.') return;
                if (isNaN(newValue)) {
                    scope.wks.number = oldValue;
                }
            });
        }
    };
});

function getRandomColor() {
    var letters = '0123456789ABCDEF';
    var color = '#';
    for (var i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return color;
}
